load ../build/A.txt
load ../build/B.txt
load ../build/steady_state.txt
copyfile('../build/hpv_rhs.c')

n_states = 249;
n_inputs = 10;

x = steady_state(1:n_states);
u = steady_state(end-n_inputs-2+1:end);
%the steady model in casadi has different inputs
u = [u(1:2); u(4:5); u(7:end)];

p = [200; 30];
B = B(1:n_states, 1:n_inputs) + A(1:n_states, end-n_inputs+1:end);
A = A(1:n_states, 1:n_states);

save data_ss.mat x u p A B
