% Elspot prices at Nord Pool Spot (EUR/MWh)
% Data from http://www.nordpoolspot.com/reports/systemprice
% Data aquired on 18/02/2011
% Price for 18/02/2011

pr = [63.23, 62.39, 62.03, 62.30, 63.05, 65.04, 65.78, ...
    67.39, 67.15, 66.73, 66.53, 66.44, 66.20, 66.19, ...
    66.26, 66.50, 67.22, 67.87, 69.06, 67.00, 66.25, ...
    66.00, 65.30, 64.35];

% The prices in the previous vector change every hour. Therefore, since
% the inputs of the HPV planet can be changed every 30 minutes  we "double"
% the vector

tmp = pr;
pr(1:2:48) = tmp;
pr(2:2:48) = tmp;

avg_pr = 65.68;

% Computation of the coefficients for the terminal cost (which give a price to the water contained in the system)
% the price vectors associated to the state vectors of every subsystem are will be denoted by 
% end_pr1
% end_pr2
% end_pr3
% end_pr4
% end_pr5
% end_pr6
% end_pr7
% end_pr8


% declaration of some data needed for the calculation. A description can be found in the pdf file.
h_R1_min = 14.5;
h_R1_max = 17.5;
h_R2_min = 16.5;
h_R2_max = 19.5;
h_R3_min = 21.5;
h_R3_max = 24.5;
h_R4_min = 17.5;
h_R4_max = 20.5;
h_R5_min = 13.5;
h_R5_max = 16.5;
h_R6_min = 11.5;
h_R6_max = 14.5;
h_T1 = 223;
h_T2 = 233;
N_cells = 20;
dz_R1 = 10000/N_cells;
dz_R2 = 8000/N_cells;
dz_R3 = 6000/N_cells;
dz_R4 = 8000/N_cells;
dz_R5 = 6000/N_cells;
dz_R6 = 8000/N_cells;
w1_R1 = 30;
wN_R1 = 50;
w1_R2 = 40;
wN_R2 = 45;
w1_R3 = 40;
wN_R3 = 55;
w1_R4 = 55;
wN_R4 = 45;
w1_R5 = 50;
wN_R5 = 60;
w1_R6 = 60;
wN_R6 = 80;
S_L1 = 10000;
S_L2 = 5000;
S_L3 = 10000;

h1_avg = h_T1; % average turbine head for system 1
h2_avg = h_T2; % average turbine head for system 2
h3_avg = (h_R1_min+h_R1_max)/2; % average turbine head for system 3
h4_avg = (h_R2_min+h_R2_max)/2; % average turbine head for system 3
h5_avg = (h_R3_min+h_R3_max)/2; % average turbine head for system 3
h6_avg = (h_R4_min+h_R4_max)/2; % average turbine head for system 3
h7_avg = (h_R5_min+h_R5_max)/2; % average turbine head for system 3
h8_avg = (h_R6_min+h_R6_max)/2; % average turbine head for system 3

pmc1 = h1_avg*avg_pr/(3600*1e6)*8000.0; % water price in EUR/m^3 (assuming the water will only go through the turbines of this system)
pmc2 = h2_avg*avg_pr/(3600*1e6)*8000.0; % water price in EUR/m^3 (assuming the water will only go through the turbines of this system)
pmc3 = h3_avg*avg_pr/(3600*1e6)*8000.0; % water price in EUR/m^3 (assuming the water will only go through the turbines of this system)
pmc4 = h4_avg*avg_pr/(3600*1e6)*8000.0; % water price in EUR/m^3 (assuming the water will only go through the turbines of this system)
pmc5 = h5_avg*avg_pr/(3600*1e6)*8000.0; % water price in EUR/m^3 (assuming the water will only go through the turbines of this system)
pmc6 = h6_avg*avg_pr/(3600*1e6)*8000.0; % water price in EUR/m^3 (assuming the water will only go through the turbines of this system)
pmc7 = h7_avg*avg_pr/(3600*1e6)*8000.0; % water price in EUR/m^3 (assuming the water will only go through the turbines of this system)
pmc8 = h8_avg*avg_pr/(3600*1e6)*8000.0; % water price in EUR/m^3 (assuming the water will only go through the turbines of this system)

pmc1t = pmc1 + pmc4 + pmc5 + pmc6 + pmc7 + pmc8; % total water price in EUR/m^3 (assuming the water will go through a standard path)
pmc2t = pmc2 + pmc7 + pmc8;
pmc3t = pmc3 + pmc4 + pmc5 + pmc6 + pmc7 + pmc8;
pmc4t = pmc4 + pmc5 + pmc6 + pmc7 + pmc8;
pmc5t = pmc5 + pmc6 + pmc7 + pmc8;
pmc6t = pmc6 + pmc7 + pmc8;
pmc7t = pmc7 + pmc8;
pmc8t = pmc8;

% definition of the vector used to define the cost of stored water
end_pr1(1) = pmc1t * S_L1; 
end_pr1(2) = pmc1t * S_L2;

end_pr2 = pmc2t * S_L3;

end_pr3 = pmc3t*dz_R1*linspace(w1_R1, wN_R1, N_cells);
end_pr4 = pmc4t*dz_R2*linspace(w1_R2, wN_R2, N_cells);
end_pr5 = pmc5t*dz_R3*linspace(w1_R3, wN_R3, N_cells);
end_pr6 = pmc6t*dz_R4*linspace(w1_R4, wN_R4, N_cells);
end_pr7 = pmc7t*dz_R5*linspace(w1_R5, wN_R5, N_cells);
end_pr8 = pmc8t*dz_R6*linspace(w1_R6, wN_R6, N_cells);


save price.mat pr avg_pr end_pr1 end_pr2 end_pr3 end_pr4 end_pr5 end_pr6 end_pr7 end_pr8