% This script should be used to generate the power profile to be followed in the tracking scenario.
% Modify the value of perc to get a different power profile
% power_reference has a length equal to 48 (which corresponds to 24 hours).
% If you need a longer reference, you can just repeat power_reference (e.g. power_ref=[power_ref, power_ref] )

% ATTENTION!!! the power is expressed in Mw

% Computation of the power producxed at steady state
p_steady_state = 8000*( (x(1)+223-x(75))*u(1) + ...
            (x(3)+233-x(116))*u(3) + ...
            (x(44)-x(65))*u(5) + ...
            (x(85)-x(106))*u(6) + ...
            (x(126)-x(147))*u(7) + ...
            (x(167)-x(188))*u(8) + ...
            (x(208)-x(229))*u(9) + ...
            (x(249)-2)*u(10) ); 

perc = 20; %max variation (percentage)

%variation = [...
%   -0.7071, -0.7671, -0.7831, -0.7912, -0.8072, -0.8233, -0.8153, -0.8072, ...
%   -0.8795, -0.8956, -1.0000, -0.9920, -0.9438, -0.8715, -0.7269, -0.6466, ...
%   -0.4137, -0.2851, -0.0522, 0.1486, 0.3333, 0.3333, 0.3253, 0.3574, ...
%    0.4297, 0.4378, 0.4297, 0.4217, 0.3896, 0.3896, 0.3896, 0.3815, ...
%    0.4940, 0.5502, 0.7510, 0.8474, 1.0000, 0.9920, 0.8956, 0.8474, ...
%    0.7510, 0.6466, 0.4538, 0.3815, 0.1406, 0.0040, -0.2450, -0.5497];
   
variation = [...
    -0.6459, -0.7007, -0.7153, -0.7227, -0.7374, -0.7521, -0.7448, -0.7374, ...
    -0.8034, -0.8181, -0.9135, -0.9062, -0.8621, -0.7961, -0.6640, -0.5907, ...
    -0.3779, -0.2604, -0.0477, 0.1486, 0.3333, 0.3333, 0.3253, 0.3574, ...
    0.4297, 0.4378, 0.4297, 0.4217, 0.3896, 0.3896, 0.3896, 0.3815, ...
    0.4940, 0.5502, 0.7510, 0.8474, 1.0000, 0.9920, 0.8956, 0.8474, ...
    0.7510, 0.6466, 0.4538, 0.3815, 0.1406, 0.0040, -0.2238, -0.5021];


power_ref = p_steady_state*(1+(perc/100)*variation);
