clear all

% load steady-state data
ss = load('data_ss.mat');

x0 = ss.x*1.10; %initial state
u0 = ss.u*1.10; %input
p0 = ss.p; %parameter
T = [0, 1800]; % integration interval
A = ss.A; % state matrix of the linearized system
B = ss.B; % input matrix of the linearized system

% definition of the function handle passed to the integrator
f = @(t, x)(hpv(t, x, u0, p0));

% integration
[tout, xout] = ode45(f,T, x0);

xf = xout(end,:)'; %state at the end of the interval

% computation of xf predicted by the linearized model
xfl = ss.x + A*(x0-ss.x) + B*(u0-ss.u);


% checking if the model is nearly linear
disp('The mismatch between the linear and nonlinear model is (infinity norm of the realtive error)')
disp(norm( 2*(xf-xfl)./(xf+xfl), inf))
disp('This number should be small if the model is nearly linear!')

