% load steady-state data
ss = load('data_ss.mat');

x0 = ss.x; %initial state
u = ss.u; %input
p = ss.p; %parameter
T = [0, 18000]; % integration interval
p(1)=-10
% definition of the function handle passed to the integrator
f = @(t, x)(hpv(t, x, u, p));

% integration
% ATTENTION!!! An integrator which is suitable for stiff ODEs must be used!
[tout, xout] = ode45(f,T, x0);

% checking we have a real steady state ;-)
disp('The norm of the variation in the state is equal to')
disp(norm(x0-xout(end,:)'))
disp('This number should be small. If not there is something wrong in the model!')

