function [xf]=hpv(x0, u, p)
%[xf]=hpv(x0, u, p)
%
%Calculates the ODE r.h.s. for the HPV model
%Inputs:
% -x0: state vector
% -u: input vector
% -p: parameter vector
%
% x0 contains the states of the system in the following order:
% h_L1, h_L2, h_L3, x_S3, x_S4, x_S5, x_S6, x_S7, x_S8
% where x_S3, ... ,x_S8 are the states of the subsystem 3 to 8.
% x_S3 = [q_1, ..., q_N, h_1, ... , h_(N+1) ]
% x_S4 = [q_1, ..., q_N, h_1, ... , h_(N+1) ]
% x_S5 = [q_1, ..., q_N, h_1, ... , h_(N+1) ]
% x_S6 = [q_1, ..., q_N, h_1, ... , h_(N+1) ]
% x_S7 = [q_1, ..., q_N, h_1, ... , h_(N+1) ]
% x_S8 = [q_1, ..., q_N, h_1, ... , h_(N+1) ]
% 
% u contains the inputs of the system in the following order
% q_T1, q_C1, q_T2, q_C2, q_R1, q_R2, q_R3, q_R4, q_R5, q_R6
%
% q_C1 is positive when C1 functions as a turbine and negative when it functions as a pump
% q_C2 is positive when C2 functions as a turbine and negative when it functions as a pump
%
% p contains the following variables
% q_in, q_tributary
%
% For an example on how to use this function see hpv_integrate.m
%
% Units of measure:
% -all levels are expressed in m (meters)
% -all the flows are expressed in m^3/s (cubic meters per second)