#include "mex.h"

#define N_STATES 249
#define N_INPUTS 10
#define N_STATES_INTERFACE 261
#define N_INPUTS_INTERFACE 14

int evaluate(double** x, double** r);

void mexFunction(int nlhs, mxArray *plhs[ ],int nrhs, const mxArray *prhs[ ]) {
  
  int nRows1, nCols1; /*dimensions of first input argument*/
  double *dPtr1; /*data pointer for the first input argument*/
  int nRows2, nCols2; /*dimension of second input argument*/
  double *dPtr2; /*data pointer for the second input argument*/
  int nRows3, nCols3; /*dimension of third input argument*/
  double *dPtr3; /*data pointer for the third input argument*/   
  int nRows4, nCols4; /*dimensions of fourth input argument*/
  double *dPtr4; /*data pointer for the fourth input argument*/
  double *dPtr; /*data pointer for the output argument*/
  
  double x0[N_STATES_INTERFACE]; /*state vector for interfaced function (in the interfaced function the dimension are not the same)*/
  double xT[N_STATES_INTERFACE]; /*state vector for interfaced function (in the interfaced function the dimension are not the same)*/
  double u[N_INPUTS_INTERFACE]; /*input vector for interfaced function*/
  double t[1]; /*interface requires an input which represents time*/
  double d_x[1]; /*interface requires an input which represents time derivatives of the state*/
  double* x[4]; /*input for function interfaced*/
  double* r[1]; /*result for function interfaced*/
  
  int ind; /*index for loops*/
  
  /*checking number of arguments*/
  if (nrhs != 4) {
    mexErrMsgTxt("Four input argument expected");
  }
  if (nlhs > 1) {
    mexErrMsgTxt("No more than one output argument are expected");
  }
  
  nRows1 = mxGetM(prhs[0]);
  nCols1 = mxGetN(prhs[0]);
  dPtr1 = mxGetPr(prhs[0]);
  nRows2 = mxGetM(prhs[1]);
  nCols2 = mxGetN(prhs[1]);
  dPtr2 = mxGetPr(prhs[1]);
  nRows3 = mxGetM(prhs[2]);
  nCols3 = mxGetN(prhs[2]);
  dPtr3 = mxGetPr(prhs[2]);
  nRows4 = mxGetM(prhs[3]);
  nCols4 = mxGetN(prhs[3]);
  dPtr4 = mxGetPr(prhs[3]);
  
  /*checking input dimensions*/
  if ( nRows1*nCols1!=1){
    mexErrMsgTxt("First argument must be a scalar");
  }
  if ( (nRows2!=1 && nCols2!=1) || (nRows2*nCols2!=N_STATES) ){
    mexErrMsgTxt("Second argument must be a vector of size 249");
  }
  if ( (nRows3!=1 && nCols3!=1) || (nRows3*nCols3!=N_INPUTS) ){
    mexErrMsgTxt("Third argument must be a vector of size 10");
  }
  if ( (nRows4!=1 && nCols4!=1) || (nRows4*nCols4!=2) ){
    mexErrMsgTxt("Fourth argument must be a vector of size 2");
  }
  
  t[0] = dPtr1[0];
  
  /*Mapping for the input vector*/
  u[0] = dPtr3[0];
  u[1] = dPtr3[1];
  u[2] = 0.0;
  u[3] = dPtr3[2];
  u[4] = dPtr3[3];
  u[5] = 0.0;
  u[6] = dPtr3[4];
  u[7] = dPtr3[5];
  u[8] = dPtr3[6];
  u[9] = dPtr3[7];
  u[10] = dPtr3[8];
  u[11] = dPtr3[9];
  u[12] = dPtr4[0];
  u[13] = dPtr4[1];
  
  for(ind=0; ind<N_STATES; ind++){
    x0[ind] = dPtr2[ind];
  }
  /*The model contains some extra smoothing states for the input which are not needed in matlab*/
  for(ind=0; ind<N_STATES_INTERFACE-N_STATES; ind++){
    x0[N_STATES+ind] = u[ind];
  }
  
  x[0] = t;
  x[1] = x0;
  x[2] = u;
  x[3] = d_x;
  r[0] = xT;
  
  evaluate(x, r);
  
  /*allocating output vector*/
  plhs[0] = mxCreateDoubleMatrix(N_STATES, 1, mxREAL);
  dPtr = mxGetPr(plhs[0]);
  
  for(ind=0; ind<N_STATES; ind++){
    dPtr[ind] = xT[ind];
  }
}
  